/******************************************************************************/
#include "stdafx.h"
/******************************************************************************

   Define your custom player character structure basing on already defined Game::Chr
   Game::Chr is a structure which handles the most basic character methods
   including : movement, animations, physics and actions

/******************************************************************************/
struct Player : Game::Chr // extend character structure by defining a player class based on the character
{
   virtual Bool update(); // here we'll update the player (please note that this is a virtual method)
};
/******************************************************************************/
Bool Player::update()
{
   // here we update character input according to mouse and keyboard

   // before we set the input, we need to check if the character isn't controlled by an automatic action
   if(action)
   {
      // if it's controlled by an action we leave the input with no changes,
      // however we can optionally break that action, by pressing for example movement keys
      if(Kb.b(KB_W) || Kb.b(KB_S) || Kb.b(KB_A) || Kb.b(KB_D) || Kb.b(KB_Q) || Kb.b(KB_E))actionBreak();
   }

   if(!action) // if the character isn't controlled by an automatic action, we can set the input
   {
      // turn & move
      input.anglei.x=Kb.b(KB_Q)-Kb.b(KB_E);
      input.anglei.y=Kb.b(KB_T)-Kb.b(KB_G);
      input.diri  .x=Kb.b(KB_D)-Kb.b(KB_A);
      input.diri  .z=Kb.b(KB_W)-Kb.b(KB_S);
      input.diri  .y=Kb.b(KB_SPACE)-Kb.b(KB_LSHIFT);

      // dodge, crouch, walk, jump
      input.dodge = Kb.bd(KB_D)-Kb.bd(KB_A);
      input.crouch= Kb.b (KB_LSHIFT);
      input.walk  = Kb.b (KB_LCTRL );
      input.jump  =(Kb.bp(KB_SPACE) ? 3.5 : 0);

      // mouse turn
      Flt max=DegToRad(900)*Tm.d,
          dx =Ms.dir_ds.x*1.7,
          dy =Ms.dir_ds.y*1.7*Ms.inv();
      angle.x-=Mid(dx,-max,max);
      angle.y+=Mid(dy,-max,max);

      // ready stance change
      ready^=Kb.bp(KB_R);
   }

   return __super::update(); // call Game::Chr::update on which Player is based on
}
/******************************************************************************/
Actor  ground; // ground actor
Player player; // player
/******************************************************************************/
void InitPre()
{
   App.name="Game Character";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).sync(true);

   Cam.dist=5;
}
/******************************************************************************/
Bool Init()
{
   Physics.create();
   ground .create(Box(15,1,15,Vec(0,-2,0)),0);

   player.create(Vec(0,0,0),1.8,"../data/obj/chr/human/0.mesh"); // create player by passing position, height, mesh, and default skeleton

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;

   Physics.sim().get();

   player.update(); // update player

   Cam.setSpherical(player.ctrl.actor.pos()+Vec(0,1,0),player.angle.x,player.angle.y,0,Cam.dist*ScaleMul(Ms.wheel*-0.2)).updateVelocities().set(); // update camera according to player angles and mouse wheel

   return true;
}
/******************************************************************************/
void Draw()
{
   D.clear();
   LightDir(1,Cam.matrix.z).set();

   ground.draw(); // draw ground actor
   player.draw(); // draw player
}
/******************************************************************************/
